<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" version="1.0" encoding="iso-8859-1" indent="yes"/>
 <xsl:template match="/">
  <pictures>
    <xsl:apply-templates select="CatalogType/MediaItemList" />
  </pictures>
 </xsl:template>
 <xsl:template match="MediaItemList">
   <xsl:for-each select="MediaItem">
   <picture>
	<Filename><xsl:value-of select="AssetProperties/Filename"/></Filename>
	<Filepath><xsl:value-of select="AssetProperties/Filepath"/></Filepath>
	<UniqueID><xsl:value-of select="AssetProperties/UniqueID"/></UniqueID>
	<Label><xsl:value-of select="AssetProperties/Label"/></Label>
	<Rating><xsl:value-of select="AssetProperties/Rating"/></Rating>
	<MediaType><xsl:value-of select="AssetProperties/MediaType"/></MediaType>
	<FileSize><xsl:value-of select="AssetProperties/FileSize"/></FileSize>
	<Created><xsl:value-of select="AssetProperties/Created"/></Created>
	<Modified><xsl:value-of select="AssetProperties/Modified"/></Modified>
	<Added><xsl:value-of select="AssetProperties/Added"/></Added>
	<Annotated><xsl:value-of select="AssetProperties/Annotated"/></Annotated>
	<Width><xsl:value-of select="MediaProperties/Width"/></Width>
	<Height><xsl:value-of select="MediaProperties/Height"/></Height>
	<Resolution><xsl:value-of select="MediaProperties/Resolution"/></Resolution>
	<Depth><xsl:value-of select="MediaProperties/Depth"/></Depth>
	<ViewRotation><xsl:value-of select="MediaProperties/ViewRotation"/></ViewRotation>
	<SampleColor><xsl:value-of select="MediaProperties/SampleColor"/></SampleColor>
	<Pages><xsl:value-of select="MediaProperties/Pages"/></Pages>
	<ColorSpace><xsl:value-of select="MediaProperties/ColorSpace"/></ColorSpace>
	<Compression><xsl:value-of select="MediaProperties/Compression"/></Compression>
	<PrimaryEncoding><xsl:value-of select="MediaProperties/PrimaryEncoding"/></PrimaryEncoding>
	<ColorProfile><xsl:value-of select="MediaProperties/ColorProfile"/></ColorProfile>
	<AnnotationWriter><xsl:value-of select="AnnotationFields/AnnotationWriter"/></AnnotationWriter>
	<Author><xsl:value-of select="AnnotationFields/Author"/></Author>
	<AuthorTitle><xsl:value-of select="AnnotationFields/AuthorTitle"/></AuthorTitle>
	<Categories><xsl:value-of select="AnnotationFields/Categories"/></Categories>
	<Category><xsl:value-of select="AnnotationFields/Category"/></Category>
	<City><xsl:value-of select="AnnotationFields/City"/></City>
	<Copyright><xsl:value-of select="AnnotationFields/Copyright"/></Copyright>
	<CopyrightNotice><xsl:value-of select="AnnotationFields/CopyrightNotice"/></CopyrightNotice>
	<Country><xsl:value-of select="AnnotationFields/Country"/></Country>
	<CountryCode><xsl:value-of select="AnnotationFields/CountryCode"/></CountryCode>
	<Creator><xsl:value-of select="AnnotationFields/Creator"/></Creator>
	<CreatorAddress><xsl:value-of select="AnnotationFields/CreatorAddress"/></CreatorAddress>
	<CreatorCity><xsl:value-of select="AnnotationFields/CreatorCity"/></CreatorCity>
	<CreatorCountry><xsl:value-of select="AnnotationFields/CreatorCountry"/></CreatorCountry>
	<CreatorEmail><xsl:value-of select="AnnotationFields/CreatorEmail"/></CreatorEmail>
	<CreatorPhone><xsl:value-of select="AnnotationFields/CreatorPhone"/></CreatorPhone>
	<CreatorPostcode><xsl:value-of select="AnnotationFields/CreatorPostcode"/></CreatorPostcode>
	<CreatorState><xsl:value-of select="AnnotationFields/CreatorState"/></CreatorState>
	<CreatorTitle><xsl:value-of select="AnnotationFields/CreatorTitle"/></CreatorTitle>
	<CreatorURL><xsl:value-of select="AnnotationFields/CreatorURL"/></CreatorURL>
	<Credit><xsl:value-of select="AnnotationFields/Credit"/></Credit>
	<DateCreated><xsl:value-of select="AnnotationFields/DateCreated"/></DateCreated>
	<Caption><xsl:value-of select="AnnotationFields/Caption"/></Caption>
	<DescriptionWriter><xsl:value-of select="AnnotationFields/DescriptionWriter"/></DescriptionWriter>
	<Fixture><xsl:value-of select="AnnotationFields/Fixture"/></Fixture>
	<EventDate><xsl:value-of select="AnnotationFields/EventDate"/></EventDate>
	<Genre><xsl:value-of select="AnnotationFields/Genre"/></Genre>
	<Headline><xsl:value-of select="AnnotationFields/Headline"/></Headline>
	<Instructions><xsl:value-of select="AnnotationFields/Instructions"/></Instructions>
	<IntellectualGenre><xsl:value-of select="AnnotationFields/IntellectualGenre"/></IntellectualGenre>
	<JobIdentifier><xsl:value-of select="AnnotationFields/JobIdentifier"/></JobIdentifier>
	<Keywords><xsl:value-of select="AnnotationFields/Keywords"/></Keywords>
	<Location><xsl:value-of select="AnnotationFields/Location"/></Location>
	<People>
		<xsl:for-each select="AnnotationFields/People">
        	   <xsl:if test="position() &gt; 1">;</xsl:if>
	           <xsl:value-of select="."/>
     		</xsl:for-each>
	</People>
	<Provider><xsl:value-of select="AnnotationFields/Provider"/></Provider>
	<Scenes><xsl:value-of select="AnnotationFields/Scenes"/></Scenes>
	<Source><xsl:value-of select="AnnotationFields/Source"/></Source>
	<State><xsl:value-of select="AnnotationFields/State"/></State>
	<Status><xsl:value-of select="AnnotationFields/Status"/></Status>
	<SubjectCodes><xsl:value-of select="AnnotationFields/SubjectCodes"/></SubjectCodes>
	<Product><xsl:value-of select="AnnotationFields/Product"/></Product>
	<Transmission><xsl:value-of select="AnnotationFields/Transmission"/></Transmission>
	<URL><xsl:value-of select="AnnotationFields/URL"/></URL>
	<UsageTerms><xsl:value-of select="AnnotationFields/UsageTerms"/></UsageTerms>
	<UserField_1><xsl:value-of select="UserFields/UserField_1"/></UserField_1>
	<UserField_2><xsl:value-of select="UserFields/UserField_2"/></UserField_2>
	<UserField_3><xsl:value-of select="UserFields/UserField_3"/></UserField_3>
	<UserField_4><xsl:value-of select="UserFields/UserField_4"/></UserField_4>
	<UserField_5><xsl:value-of select="UserFields/UserField_5"/></UserField_5>
	<UserField_6><xsl:value-of select="UserFields/UserField_6"/></UserField_6>
	<UserField_7><xsl:value-of select="UserFields/UserField_7"/></UserField_7>
	<UserField_8><xsl:value-of select="UserFields/UserField_8"/></UserField_8>
	<UserField_9><xsl:value-of select="UserFields/UserField_9"/></UserField_9>
	<UserField_10><xsl:value-of select="UserFields/UserField_10"/></UserField_10>
	<UserField_11><xsl:value-of select="UserFields/UserField_11"/></UserField_11>
	<UserField_12><xsl:value-of select="UserFields/UserField_12"/></UserField_12>
	<UserField_13><xsl:value-of select="UserFields/UserField_13"/></UserField_13>
	<UserField_14><xsl:value-of select="UserFields/UserField_14"/></UserField_14>
	<UserField_15><xsl:value-of select="UserFields/UserField_15"/></UserField_15>
	<UserField_16><xsl:value-of select="UserFields/UserField_16"/></UserField_16>
	<Maker><xsl:value-of select="MetaDataFields/Maker"/></Maker>
	<Model><xsl:value-of select="MetaDataFields/Model"/></Model>
	<Software><xsl:value-of select="MetaDataFields/Software"/></Software>
	<SourceURL><xsl:value-of select="MetaDataFields/SourceURL"/></SourceURL>
	<ExifVersion><xsl:value-of select="MetaDataFields/ExifVersion"/></ExifVersion>
	<CaptureDate><xsl:value-of select="MetaDataFields/CaptureDate"/></CaptureDate>
	<ExposureProgram><xsl:value-of select="MetaDataFields/ExposureProgram"/></ExposureProgram>
	<ISOSpeedRating><xsl:value-of select="MetaDataFields/ISOSpeedRating"/></ISOSpeedRating>
	<ExposureBias><xsl:value-of select="MetaDataFields/ExposureBias"/></ExposureBias>
	<ExposureTime><xsl:value-of select="MetaDataFields/ExposureTime"/></ExposureTime>
	<Aperture><xsl:value-of select="MetaDataFields/Aperture"/></Aperture>
	<MeteringMode><xsl:value-of select="MetaDataFields/MeteringMode"/></MeteringMode>
	<LightSource><xsl:value-of select="MetaDataFields/LightSource"/></LightSource>
	<Flash><xsl:value-of select="MetaDataFields/Flash"/></Flash>
	<FocalLength><xsl:value-of select="MetaDataFields/FocalLength"/></FocalLength>
	<SensingMethod><xsl:value-of select="MetaDataFields/SensingMethod"/></SensingMethod>
	<Lens><xsl:value-of select="MetaDataFields/Lens"/></Lens>
   </picture>
   </xsl:for-each>
 </xsl:template>
</xsl:stylesheet> 